
#ifndef KMORETOOLS_EXPORT_H
#define KMORETOOLS_EXPORT_H

#ifdef KMORETOOLS_STATIC_DEFINE
#  define KMORETOOLS_EXPORT
#  define KMORETOOLS_NO_EXPORT
#else
#  ifndef KMORETOOLS_EXPORT
#    ifdef KF6MoreTools_EXPORTS
        /* We are building this library */
#      define KMORETOOLS_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define KMORETOOLS_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef KMORETOOLS_NO_EXPORT
#    define KMORETOOLS_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef KMORETOOLS_DECL_DEPRECATED
#  define KMORETOOLS_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef KMORETOOLS_DECL_DEPRECATED_EXPORT
#  define KMORETOOLS_DECL_DEPRECATED_EXPORT KMORETOOLS_EXPORT KMORETOOLS_DECL_DEPRECATED
#endif

#ifndef KMORETOOLS_DECL_DEPRECATED_NO_EXPORT
#  define KMORETOOLS_DECL_DEPRECATED_NO_EXPORT KMORETOOLS_NO_EXPORT KMORETOOLS_DECL_DEPRECATED
#endif

/* NOLINTNEXTLINE(readability-avoid-unconditional-preprocessor-if) */
#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KMORETOOLS_NO_DEPRECATED
#    define KMORETOOLS_NO_DEPRECATED
#  endif
#endif

#define KMORETOOLS_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

/* Take any defaults from group settings */
#if !defined(KMORETOOLS_NO_DEPRECATED) && !defined(KMORETOOLS_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define KMORETOOLS_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define KMORETOOLS_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(KMORETOOLS_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define KMORETOOLS_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(KMORETOOLS_NO_DEPRECATED_WARNINGS) && !defined(KMORETOOLS_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define KMORETOOLS_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define KMORETOOLS_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(KMORETOOLS_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define KMORETOOLS_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(KMORETOOLS_NO_DEPRECATED)
#  undef KMORETOOLS_DEPRECATED
#  define KMORETOOLS_DEPRECATED_EXPORT KMORETOOLS_EXPORT
#  define KMORETOOLS_DEPRECATED_NO_EXPORT KMORETOOLS_NO_EXPORT
#elif defined(KMORETOOLS_NO_DEPRECATED_WARNINGS)
#  define KMORETOOLS_DEPRECATED
#  define KMORETOOLS_DEPRECATED_EXPORT KMORETOOLS_EXPORT
#  define KMORETOOLS_DEPRECATED_NO_EXPORT KMORETOOLS_NO_EXPORT
#else
#  define KMORETOOLS_DEPRECATED KMORETOOLS_DECL_DEPRECATED
#  define KMORETOOLS_DEPRECATED_EXPORT KMORETOOLS_DECL_DEPRECATED_EXPORT
#  define KMORETOOLS_DEPRECATED_NO_EXPORT KMORETOOLS_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KMORETOOLS_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KMORETOOLS_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KMORETOOLS_NO_DEPRECATED
#  define KMORETOOLS_DISABLE_DEPRECATED_BEFORE_AND_AT 0x5f000
#endif
#ifdef KMORETOOLS_NO_DEPRECATED_WARNINGS
#  define KMORETOOLS_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KMORETOOLS_DEPRECATED_WARNINGS_SINCE
#  ifdef KMORETOOLS_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KMORETOOLS_DEPRECATED_WARNINGS_SINCE KMORETOOLS_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KMORETOOLS_DEPRECATED_WARNINGS_SINCE 0x5f000
#  endif
#endif

#ifndef KMORETOOLS_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KMORETOOLS_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KMORETOOLS_DEPRECATED
#  define KMORETOOLS_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > KMORETOOLS_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KMORETOOLS_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#endif /* KMORETOOLS_EXPORT_H */
